﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;


/* a simple custom activity with dependency properties and dependency events */
namespace Lessons.Workflows.Activities
{

	public partial class InputDependencyActivity: Activity
	{
        public static DependencyProperty TitleProperty = DependencyProperty.Register("Title", typeof(string), typeof(InputDependencyActivity), new PropertyMetadata("Dialog box title"));
        public static DependencyProperty TextProperty = DependencyProperty.Register("Text", typeof(string), typeof(InputDependencyActivity), new PropertyMetadata("Dialog box text"));
        public static DependencyProperty InputProperty = DependencyProperty.Register("Input", typeof(string), typeof(InputDependencyActivity), new PropertyMetadata("Dialog box input"));
        public static DependencyProperty ResultProperty = DependencyProperty.Register("Result", typeof(bool), typeof(InputDependencyActivity));

        public static DependencyProperty BeforeDialogEvent = DependencyProperty.Register("BeforeDialog", typeof(EventHandler<EventArgs>), typeof(InputDependencyActivity), new PropertyMetadata(null));
        public static DependencyProperty AfterDialogEvent = DependencyProperty.Register("AfterDialog", typeof(EventHandler<EventArgs>), typeof(InputDependencyActivity), new PropertyMetadata(null));
        

        public InputDependencyActivity()
		{
			InitializeComponent();
		}


        protected override ActivityExecutionStatus Execute(ActivityExecutionContext context)
        {
 
            base.RaiseGenericEvent<EventArgs>(BeforeDialogEvent, this, EventArgs.Empty);

            string S = Input;
            Result = InputDialog.Execute(Title, Text, ref S);

            if (Result)
                Input = S;
 
            base.RaiseGenericEvent<EventArgs>(AfterDialogEvent, this, EventArgs.Empty);

            /* return a status to indicate that the activity is complete */
            return ActivityExecutionStatus.Closed;
        }


        /* properties */
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        [Browsable(true)]
        public string Title
        {
            get
            {
                return ((string)(base.GetValue(TitleProperty)));
            }
            set
            {
                base.SetValue(TitleProperty, value);
            }
        }
                
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        [Browsable(true)]
        public string Text
        {
            get
            {
                return ((string)(base.GetValue(TextProperty)));
            }
            set
            {
                base.SetValue(TextProperty, value);
            }
        }

        
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        [Browsable(true)]
        public string Input
        {
            get
            {
                return ((string)(base.GetValue(InputProperty)));
            }
            set
            {
                base.SetValue(InputProperty, value);
            }
        }

        
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        [Browsable(true)]
        public bool Result
        {
            get
            {
                return ((bool)(base.GetValue(ResultProperty)));
            }
            set
            {
                base.SetValue(ResultProperty, value);
            }
        }



        /* events */
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        [Browsable(true)]
        public event EventHandler<EventArgs> BeforeDialog
        {
            add
            {
                base.AddHandler(BeforeDialogEvent, value);
            }
            remove
            {
                base.RemoveHandler(BeforeDialogEvent, value);
            }
        }

        [DesignerSerializationVisibility(DesignerSerializationVisibility.Visible)]
        [Browsable(true)]
        public event EventHandler<EventArgs> AfterDialog
        {
            add
            {
                base.AddHandler(AfterDialogEvent, value);
            }
            remove
            {
                base.RemoveHandler(AfterDialogEvent, value);
            }
        }

	}

}
